// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_IMEDIA_PLAYBACK_STATUS_CALLBACKS_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_IMEDIA_PLAYBACK_STATUS_CALLBACKS_H

#include "common.h"

/**
 * Used to communicate media playback status to the receiver library.
 */
struct MediaPlaybackStatusStruct {
    uint32_t state; /**< See enum State in MediaPlaybackStatus. */
    string media_source; /**< Source of current media. */
    uint32_t playback_seconds; /**< Current playback of song in seconds. */
    bool shuffle; /**< True if shuffle is on. */
    bool repeat; /**< True if repeat is one. */
    bool repeat_one; /**< True if repeating one song. */
};

struct MediaPlaybackMetadataStruct {
    string song; /**< Name of current song. */
    string album; /**< Album of current song. */
    string artist; /**< Artist of current song. */
    string album_art; /**< Album art in PNG format. */
    string playlist; /**< Name of the current playlist. */
    uint32_t duration_seconds; /**< Length of current song in seconds. */
    int32_t rating; /**< Rating of current song from 0-5. */
};

/**
 * This class represents an interface that every sink implementation must subclass if they wish to
 * implement the part of the GAL protocol that receives media playback status. You should also take
 * a look at the class MediaPlaybackStatusEndpoint for a pseudocode example.
 */
class IMediaPlaybackStatusCallbacks {
public:
    virtual ~IMediaPlaybackStatusCallbacks() { }

    /**
     * Called when media playback status message comes through.
     */
    virtual int mediaPlaybackStatusCallback(struct MediaPlaybackStatusStruct status) = 0;

    /**
     * Called when media playback metadata message comes through.
     */
    virtual int mediaPlaybackMetadataCallback(struct MediaPlaybackMetadataStruct metadata) = 0;
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_IMEDIA_PLAYBACK_STATUS_CALLBACKS_H
